<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDevicesTable extends Migration {

	public function up()
	{
		Schema::create('user_devices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('device_id', 256);
			$table->integer('device_type')->default('1');
			$table->string('session_id', 256);
			$table->integer('is_logout')->default('0');
			$table->datetime('login_time');
			$table->datetime('logout_time')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_devices');
	}
}