<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrendingTable extends Migration {

	public function up()
	{
		Schema::create('trending', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 125);
			$table->integer('type')->default('1');
			$table->string('media', 256);
			$table->integer('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('trending');
	}
}