<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSimplySimplifiedTable extends Migration {

	public function up()
	{
		Schema::create('simply_simplified', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('title', 256);
			$table->string('tagline', 125)->nullable();
			$table->string('thumbnail', 256);
			$table->string('video', 256);
			$table->integer('is_featured')->default('0');
			$table->integer('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('simply_simplified');
	}
}