<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('type');
			$table->string('title', 256);
			$table->string('image', 256)->nullable();
			$table->text('description')->nullable();
			$table->integer('is_view')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}