<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMainsGearBasicTable extends Migration {

	public function up()
	{
		Schema::create('mains_gear_basic', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 256);
			$table->string('tagline', 256)->nullable();
			$table->string('thumbnail', 256);
			$table->string('video', 256);
			$table->integer('is_featured')->default('0');
			$table->integer('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('mains_gear_basic');
	}
}