<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Country extends Eloquent {

	protected $table = 'countries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_code', 'currancy');

	public function dreams()
	{
		return $this->hasMany('App\Models\Dream');
	}

	public function users()
	{
		return $this->hasMany('App\Models\User');
	}

}