<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned()->nullable();
			$table->string('number');
			$table->string('name', 255);
			$table->string('street', 255);
			$table->string('zip', 255);
			$table->string('city', 255);
			$table->string('country', 255);
			$table->string('phone', 255);
			$table->string('email', 255);
			$table->char('phone_pin', 4)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}