<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkflowsTable extends Migration {

	public function up()
	{
		Schema::create('workflows', function(Blueprint $table) {
			$table->uuid('workflowsId', 36)->unique();
			$table->timestamps();
			$table->string('name');
			$table->text('description');
			$table->integer('order')->default('0');
			$table->boolean('completed');
			$table->char('workflowGroupsId', 36);
		});
	}

	public function down()
	{
		Schema::drop('workflows');
	}
}