<?php

class Match extends Eloquent {

	protected $table = 'matches';
	public $timestamps = false;
	protected $fillable = array('season_id', 'tournament_id', 'tournament_season_id', 'tournament_round_id', 'tournament_group_id', 'tour', 'play_date', 'play_time', 'team_home_id', 'team_away_id', 'result_1', 'result_2', 'result_extra_time', 'result_match', 'viewed', 'stadium_id', 'referee_id', 'description', 'status');

	public function tournament()
	{
		return $this->belongsTo('Tournament');
	}

	public function round()
	{
		return $this->belongsTo('TournamentRaund');
	}

	public function group()
	{
		return $this->belongsTo('TournamentGroup');
	}

	public function season()
	{
		return $this->belongsTo('Season');
	}

	public function teamHome()
	{
		return $this->belongsTo('Team', 'team_home_id');
	}

	public function teamAway()
	{
		return $this->belongsTo('Team', 'team_away_id');
	}

	public function stadium()
	{
		return $this->belongsTo('Stadium');
	}

	public function goals()
	{
		return $this->hasMany('MatchGoal');
	}

	public function cards()
	{
		return $this->hasMany('MatchCard');
	}

	public function players()
	{
		return $this->hasMany('MatchPlayer');
	}

	public function statistics()
	{
		return $this->hasMany('MatchStatistic');
	}

	public function referee()
	{
		return $this->belongsTo('Referee');
	}

	public function galleries()
	{
		return $this->hasOne('Gallery', 'entity');
	}

	public function coefficients()
	{
		return $this->hasMany('MatchCoefficient');
	}

}