<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchGoalsTable extends Migration {

	public function up()
	{
		Schema::create('match_goals', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('match_id')->primary()->unsigned()->index();
			$table->integer('player_id')->primary()->unsigned()->index();
			$table->smallInteger('time')->nullable();
			$table->smallInteger('overtime')->nullable();
			$table->tinyInteger('type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('match_goals');
	}
}