<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('forget_token');
    protected $hidden = array('salt', 'forget_token', 'active_token');

    public function pages()
    {
        return $this->hasMany('Page', 'author_id');
    }

    public function posts()
    {
        return $this->hasMany('User', 'author_id');
    }

}