<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TournamentSeason extends Model 
{

    protected $table = 'tournament_seasons';
    public $timestamps = false;
    protected $fillable = array('season_id', 'tournament_id', 'date_start', 'date_finish', 'lwinter_tid', 'winter_team_id', 'status', 'total_game', 'played_game', 'home_wins', 'draws', 'guest_wins', 'total_goals', 'home_goals', 'quest_goals', 'viewers');

    public function season()
    {
        return $this->belongsTo('Season');
    }

    public function tournament()
    {
        return $this->belongsTo('Tournament');
    }

    public function teams()
    {
        return $this->belongsToMany('Team', 'tournament_team', 'tournament_id', 'team_id');
    }

}