<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = false;
    protected $fillable = array('name', 'slug', 'img', 'foundation_year', 'country_id', 'city_id', 'instagram', 'facebook', 'twitter', 'site', 'type', 'about');

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function teamSeasons()
    {
        return $this->hasMany('TeamSeason');
    }

    public function galleries()
    {
        return $this->hasOne('Gallery', 'entity');
    }

    public function ratingUefa()
    {
        return $this->hasOne('TeamRatingUefa');
    }

}