<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clientes', function(Blueprint $table) {
			$table->foreign('id_pais')->references('id')->on('paises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->foreign('pais_id_conyuge')->references('id')->on('paises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hijos', function(Blueprint $table) {
			$table->foreign('id_cliente')->references('id')->on('clientes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->foreign('id_asesor')->references('id')->on('asesores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->foreign('id_cliente')->references('id')->on('clientes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->foreign('id_empleo')->references('id')->on('empleo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->foreign('id_gasto_mensual')->references('id')->on('gastos_mensuales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->foreign('id_patrimonio_proteccion')->references('id')->on('patrimonio_proteccion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->foreign('id_prioridad_riesgo_inversion')->references('id')->on('prioridad_riesgo_inversion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('propiedades', function(Blueprint $table) {
			$table->foreign('id_factfind')->references('id')->on('factfinds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ahorros', function(Blueprint $table) {
			$table->foreign('id_factfind')->references('id')->on('factfinds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prestamos_deudas', function(Blueprint $table) {
			$table->foreign('id_factfind')->references('id')->on('factfinds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('referidos', function(Blueprint $table) {
			$table->foreign('id_factfind')->references('id')->on('factfinds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('clientes', function(Blueprint $table) {
			$table->dropForeign('clientes_id_pais_foreign');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->dropForeign('clientes_pais_id_conyuge_foreign');
		});
		Schema::table('hijos', function(Blueprint $table) {
			$table->dropForeign('hijos_id_cliente_foreign');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->dropForeign('factfinds_id_asesor_foreign');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->dropForeign('factfinds_id_cliente_foreign');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->dropForeign('factfinds_id_empleo_foreign');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->dropForeign('factfinds_id_gasto_mensual_foreign');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->dropForeign('factfinds_id_patrimonio_proteccion_foreign');
		});
		Schema::table('factfinds', function(Blueprint $table) {
			$table->dropForeign('factfinds_id_prioridad_riesgo_inversion_foreign');
		});
		Schema::table('propiedades', function(Blueprint $table) {
			$table->dropForeign('propiedades_id_factfind_foreign');
		});
		Schema::table('ahorros', function(Blueprint $table) {
			$table->dropForeign('ahorros_id_factfind_foreign');
		});
		Schema::table('prestamos_deudas', function(Blueprint $table) {
			$table->dropForeign('prestamos_deudas_id_factfind_foreign');
		});
		Schema::table('referidos', function(Blueprint $table) {
			$table->dropForeign('referidos_id_factfind_foreign');
		});
	}
}