<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatrimonioProteccionTable extends Migration {

	public function up()
	{
		Schema::create('patrimonio_proteccion', function(Blueprint $table) {
			$table->increments('id');
			$table->char('acciones', 1)->nullable()->default('0');
			$table->char('fondos_inversion', 1)->nullable()->default('0');
			$table->char('plan_retiro', 1)->nullable()->default('0');
			$table->char('segura_vida', 1)->nullable()->default('0');
			$table->char('gastos_medicos', 1)->nullable()->default('0');
			$table->char('cobertura_familiar', 1)->nullable()->default('0');
			$table->char('internacional', 1)->nullable()->default('0');
			$table->char('local', 1)->nullable()->default('0');
			$table->decimal('valor_acciones', 8,2)->nullable()->default('0');
			$table->decimal('valor_inversion', 8,2)->nullable()->default('0');
			$table->decimal('valor_plan_retiro', 8,2)->nullable()->default('0');
			$table->decimal('valor_cobertura_seguro_vida', 8,2)->nullable()->default('0');
			$table->string('conoce_otro_asesor', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('patrimonio_proteccion');
	}
}