<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostboxTable extends Migration {

	public function up()
	{
		Schema::create('postbox', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('procedure_id')->unsigned()->nullable();
			$table->bigInteger('payment_id')->unsigned()->nullable();
			$table->bigInteger('consumption_unit_id')->unsigned()->nullable();
			$table->bigInteger('message_id')->unsigned()->nullable();
			$table->string('type');
			$table->timestamp('read_at');
			$table->string('subject')->nullable();
			$table->longText('message')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('postbox');
	}
}