<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMeterCountsTable extends Migration {

	public function up()
	{
		Schema::create('meter_counts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('meter_id')->unsigned();
			$table->string('ref_id');
			$table->integer('count')->unsigned();
			$table->timestamp('count_at');
			$table->string('reading_type');
			$table->bigInteger('submitted_user_id')->unsigned()->nullable();
			$table->string('submitted_user')->nullable();
			$table->timestamp('submitted_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('meter_counts');
	}
}