<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tenant_id')->unsigned();
			$table->string('ref_id');
			$table->string('organization');
			$table->string('addition');
			$table->string('name');
			$table->smallInteger('postalcode')->unsigned();
			$table->string('locality')->nullable();
			$table->string('street');
			$table->string('country');
			$table->string('payment_method');
			$table->string('sepa_iban');
			$table->string('sepa_bank');
			$table->string('sepa_bic');
			$table->string('sepa_reference');
			$table->string('sepa_applies_at');
			$table->string('sepa_accountholder');
			$table->string('billing_organization');
			$table->string('billing_addition');
			$table->string('billing_name');
			$table->string('billing_street');
			$table->smallInteger('billing_postalcode')->unsigned();
			$table->string('billing_locality');
			$table->string('billing_country');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}