<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function Student()
	{
		return $this->hasOne('App\Student', 'user_id');
	}

	public function Teacher()
	{
		return $this->hasOne('App\Teacher', 'user_id');
	}

	public function Parent()
	{
		return $this->hasOne('App\Parents', 'user_id');
	}

	public function Librarian()
	{
		return $this->hasOne('App\Librarian', 'user_id');
	}

	public function Accountant()
	{
		return $this->hasOne('App\Accountant', 'user_id');
	}

	public function Messages()
	{
		return $this->hasMany('App\Message', 'user_id');
	}

	public function Logs()
	{
		return $this->hasMany('App\Logs', 'user_id');
	}

	public function Admin()
	{
		return $this->hasOne('App\Admin', 'user_id');
	}

}