<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('name', 255);
			$table->integer('parent_id');
			$table->integer('calss_id');
			$table->integer('section_id');
			$table->integer('roll');
			$table->string('Birthday', 50);
			$table->enum('Gender', array('male', 'female'));
			$table->text('Address');
			$table->string('Phone', 50);
			$table->integer('dormitory_id');
			$table->integer('transport_id');
			$table->string('photo');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}