<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserProject extends Eloquent {

	protected $table = 'user_project';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'user_id');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'uesr_id');
	}

}