<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskTable extends Migration {

	public function up()
	{
		Schema::create('task', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->nullable();
			$table->integer('created_by')->nullable();
			$table->string('title')->nullable();
			$table->text('details')->nullable();
			$table->string('status')->nullable();
			$table->datetime('due_date')->nullable();
			$table->string('total_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('task');
	}
}