<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->text('description')->nullable();
			$table->integer('total_days')->nullable();
			$table->string('status')->nullable();
			$table->double('progress')->nullable();
			$table->double('time_rate')->nullable();
			$table->integer('created_by')->nullable();
			$table->double('total')->nullable();
			$table->double('remain')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}