<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectPayment extends Model 
{

    protected $table = 'project_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'date', 'amount', 'created_by');

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function created_by()
    {
        return $this->belongsTo('User', 'created_by');
    }

}