<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permission extends Model 
{

    protected $table = 'permissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function permissionTranslation()
    {
        return $this->hasOne('PermissionTranslation');
    }

    public function roles()
    {
        return $this->belongsToMany('Role');
    }

}