<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Director extends Model 
{

    protected $table = 'directors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function directorTranslations()
    {
        return $this->hasMany('DirectorTranslation');
    }

    public function jobTitle()
    {
        return $this->hasOne('JobTitle');
    }

    public function chairManSpeech()
    {
        return $this->hasOne('Speech');
    }

}