<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DayOfWeek extends Model 
{

    protected $table = 'daysOfWeek';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function dayOfWeekTranslation()
    {
        return $this->hasMany('DayOfWeekTranslation');
    }

    public function workTimes()
    {
        return $this->hasMany('WorkTime');
    }

}