<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Speech extends Eloquent {

	protected $table = 'speeches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function dirctor()
	{
		return $this->belongsTo('Director');
	}

	public function images()
	{
		return $this->morphMany('Image');
	}

}