<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function serviceTranslations()
	{
		return $this->hasMany('ServiceTranslation');
	}

	public function images()
	{
		return $this->morphMany('Image');
	}

}