<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Partner extends Eloquent {

	protected $table = 'partners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function partnerTranslations()
	{
		return $this->hasMany('PartnerTranslation');
	}

	public function images()
	{
		return $this->morphMany('Image');
	}

}