<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class News extends Eloquent {

	protected $table = 'news';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function newTranslation()
	{
		return $this->hasMany('NewTranslation');
	}

	public function images()
	{
		return $this->morphMany('Image');
	}

	public function newsCategory()
	{
		return $this->belongsTo('NewsCategory');
	}

}