<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DayOfWeek extends Eloquent {

	protected $table = 'daysOfWeek';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function dayOfWeekTranslation()
	{
		return $this->hasMany('DayOfWeekTranslation');
	}

	public function workTimes()
	{
		return $this->hasMany('WorkTime');
	}

}