<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Country extends Eloquent {

	protected $table = 'countries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function images()
	{
		return $this->morphMany('Image');
	}

	public function countryTranslations()
	{
		return $this->hasMany('CountryTranslation');
	}

}