<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Upload extends Eloquent {

	protected $table = 'uploads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'name', 'path', 'extension');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

}