<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProceduresTable extends Migration {

	public function up()
	{
		Schema::create('procedures', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('secteur_id')->unsigned()->index();
			$table->string('libelle');
			$table->text('description')->nullable();
			$table->string('submission_form_url')->nullable();
			$table->string('dossier_state_url')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('procedures');
	}
}