<?php

namespace Discovereel\Users;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function reels()
	{
		return $this->hasMany('Reel');
	}

	public function roles()
	{
		return $this->belongsToMany('Role')->withTimestamps();
	}

}