<?php

namespace Discovereel\Sections;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Section extends Eloquent {

	protected $table = 'sections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function theme()
	{
		return $this->belongsTo('Theme');
	}

	public function columns()
	{
		return $this->belongsToMany('Column')->withTimestamps();
	}

}