<?php

namespace Discovereel\Objects;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Object extends Eloquent {

	protected $table = 'object';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function objectType()
	{
		return $this->belongsTo('ObjectType');
	}

	public function reel()
	{
		return $this->belongsTo('Reel');
	}

	public function lists()
	{
		return $this->belongsToMany('List');
	}

}