<?php

namespace Discovereel\Lists;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class List extends Eloquent {

	protected $table = 'lists';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function columns()
	{
		return $this->belongsToMany('Column');
	}

	public function objects()
	{
		return $this->belongsToMany('Object');
	}

}