<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tema_digesto extends Eloquent {

	protected $table = 'tema_digesto';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function digesto()
	{
		return $this->belongsTo('App\Models\Digesto', 'id_dig_general');
	}

	public function tema()
	{
		return $this->belongsTo('App\Models\Tema', 'id_tema');
	}

	public function tipo_tema()
	{
		return $this->hasMany('App\Models\Tema_digesto', 'id_tipo_tema');
	}

}