<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('firstname', 256);
			$table->string('lastname', 256);
			$table->integer('age');
			$table->bigInteger('avatar_id');
			$table->integer('particularity_index');
			$table->text('comment');
			$table->bigInteger('normal_weight');
			$table->bigInteger('weight');
			$table->bigInteger('height');
			$table->string('left_hear_media', 256);
			$table->string('right_hear_media');
			$table->string('left_eye_media', 256);
			$table->string('right_eye_media', 256);
			$table->string('tongue_media', 256);
			$table->integer('temperature');
			$table->bigInteger('personal_situation_id');
			$table->integer('sys_tension');
			$table->integer('dia_tension');
			$table->integer('pul_tension');
			$table->integer('spo2_saturation');
			$table->integer('prbmp_saturation');
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}