<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDrugTherapiesTable extends Migration {

	public function up()
	{
		Schema::create('drug_therapies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id');
			$table->bigInteger('medecine_id');
			$table->integer('dosage_type_index');
			$table->string('dosage_attribute', 256);
			$table->decimal('quantity_weight', 5.2);
			$table->integer('number_per_day');
			$table->integer('galenic_index');
			$table->integer('injection_way_index');
			$table->integer('duration');
			$table->integer('duration_type_index');
			$table->integer('treatment_rythme_index');
			$table->bigInteger('rythme');
			$table->text('sup_factor');
			$table->text('complement');
			$table->bigInteger('scenario_id');
			$table->integer('points');
			$table->boolean('is_mandatory');
			$table->boolean('is_forbidden');
		});
	}

	public function down()
	{
		Schema::drop('drug_therapies');
	}
}