<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('sub_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->boolean('is_active')->default(1);
			$table->bigInteger('category_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sub_categories');
	}
}