<?php

namespace App\Models;

class ProductPromotions extends Eloquent {

	protected $table = 'product_promotions';
	public $timestamps = true;
	protected $fillable = array('promotional_price', 'promotion_id', 'product_id');
	protected $visible = array('promotional_price', 'promotion_id', 'product_id');

	public function promotions()
	{
		return $this->belongsTo('App\Models\Promotion', 'promotion_id');
	}

	public function products()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

}