<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommandProductsTable extends Migration {

	public function up()
	{
		Schema::create('command_products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('quantity')->nullable();
			$table->string('unit', 50)->nullable();
			$table->decimal('unit_price', 8,2)->nullable()->index();
			$table->decimal('subtotal', 8,2)->nullable();
			$table->integer('command_id')->unsigned();
			$table->integer('product_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('command_products');
	}
}