<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('firstname', 200)->nullable()->index();
			$table->string('lastname', 200)->nullable()->index();
			$table->string('email', 200)->unique()->nullable();
			$table->string('ssn', 250)->nullable();
			$table->string('passport', 250)->nullable();
			$table->timestamp('date_of_birth')->nullable();
			$table->timestamp('identity_verified_at')->nullable();
			$table->bigInteger('role_id')->unsigned();
			$table->integer('location_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}