<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobTitleRequirementsTable extends Migration {

	public function up()
	{
		Schema::create('job_title_requirements', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('job_title_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->bigInteger('company_id')->unsigned()->nullable();
			$table->bigInteger('job_title_requirement_type_id')->unsigned();
			$table->string('description', 100)->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('job_title_requirements');
	}
}