<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('jugadores', function(Blueprint $table) {
			$table->foreign('obra_social_id')->references('id')->on('obras_sociales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jugadores', function(Blueprint $table) {
			$table->foreign('categoria_id')->references('id')->on('categorias')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categorias_usuarios', function(Blueprint $table) {
			$table->foreign('categoria_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categorias_usuarios', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('jugadores', function(Blueprint $table) {
			$table->dropForeign('jugadores_obra_social_id_foreign');
		});
		Schema::table('jugadores', function(Blueprint $table) {
			$table->dropForeign('jugadores_categoria_id_foreign');
		});
		Schema::table('categorias_usuarios', function(Blueprint $table) {
			$table->dropForeign('categorias_usuarios_categoria_id_foreign');
		});
		Schema::table('categorias_usuarios', function(Blueprint $table) {
			$table->dropForeign('categorias_usuarios_user_id_foreign');
		});
	}
}