<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function subscriptions()
	{
		return $this->hasMany('App\UserSubscriptions', 'user_id');
	}

	public function groups()
	{
		return $this->hasMany('App\Groups', 'teacher_id');
	}

}