<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('player_owners', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('player_owners', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_coach_register', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course_coaches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_coach_register', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('test_topic', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course_players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_player_register', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course_players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_player_register', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('player_testing', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('course_players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('player_testing', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('player_testing', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('test_topic')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('player_owners', function(Blueprint $table) {
			$table->dropForeign('player_owners_user_id_foreign');
		});
		Schema::table('player_owners', function(Blueprint $table) {
			$table->dropForeign('player_owners_player_id_foreign');
		});
		Schema::table('course_coach_register', function(Blueprint $table) {
			$table->dropForeign('course_coach_register_course_id_foreign');
		});
		Schema::table('course_coach_register', function(Blueprint $table) {
			$table->dropForeign('course_coach_register_user_id_foreign');
		});
		Schema::table('test_topic', function(Blueprint $table) {
			$table->dropForeign('test_topic_course_id_foreign');
		});
		Schema::table('course_player_register', function(Blueprint $table) {
			$table->dropForeign('course_player_register_course_id_foreign');
		});
		Schema::table('course_player_register', function(Blueprint $table) {
			$table->dropForeign('course_player_register_player_id_foreign');
		});
		Schema::table('player_testing', function(Blueprint $table) {
			$table->dropForeign('player_testing_course_id_foreign');
		});
		Schema::table('player_testing', function(Blueprint $table) {
			$table->dropForeign('player_testing_player_id_foreign');
		});
		Schema::table('player_testing', function(Blueprint $table) {
			$table->dropForeign('player_testing_test_id_foreign');
		});
	}
}